<?php
/* @var $dataProvider CActiveDataProvider */
/* @var $showStudent boolean */
/* @var $studentId int */
/* @var $companyId int */

$cs = Yii::app()->clientScript;
$cs->registerCoreScript('jquery.ui');
$cs->registerCssFile(Yii::app()->baseUrl.'/css/ui/themes/smoothness/jquery-ui.min.css');

$count = $dataProvider->getItemCount();
?>

<style>
	.fail {
		font-weight: bold;
		color: red;
	}
	.success {
		font-weight: bold;
		color: blue;
	}
	div[header-id] {
		font-weight: bold;
		cursor: pointer;
	}
	div[tresc-id] h1 {
		text-align:center;
	}
	div[tresc-id] img {
		max-width:80%;
	}
	#uzytkownik-zlecenia-lista a:hover {
		font-weight: initial;
	}
	#printAll, .taskOrderUpdate {
		cursor: pointer;
	}
	.pleaseCenterAlignThisColumnForMe {
		text-align: center
	}
	.orderListGroup
	{
		border: 1px solid #DDDCDC;
		border-radius: 5px;
		padding: 10px;
		margin-bottom: 10px;
		position: relative;
	}
	.orderListGroup legend {
		margin-left: 5px;
		font-weight: bold;
	}
	div.ui-datepicker.ui-widget.ui-widget-content a:hover {
		font-weight: initial
	}
</style>

<?php if ($count) :?>
<fieldset class="orderListGroup">
	<legend>Drukuj raport</legend>
	<label for="selectStartDate">Od</label> <input id="selectStartDate" name="selectStartDate" class="control-datapicker" type="text" value="" />
	<label for="selectStopDate">Do</label> <input id="selectStopDate" name="selectStopDate" class="control-datapicker" type="text" value="" />
	<button id="raportPrint" class="buttonS bGreen">Drukuj</button>
	<button id="raportPrintAll" class="buttonS bLightBlue">Drukuj wszystkie</button>
</fieldset>
<?php endif; ?>

<?php
$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'uzytkownik-zlecenia-lista',
	'dataProvider'=> $dataProvider,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		array(
			'header'=>'Dziedzina',
			'name'=>'dziedzina',
			'value'=>'"<img title=\"" . $data->idZlecenia0->dziedzina->nazwa . "\" alt=\"" . $data->idZlecenia0->dziedzina->nazwa .
				"\" src=\"" . $data->idZlecenia0->dziedzina->namesAsImageUrl . "\" />"',
			'type'=>'raw'
		),
		array(
			'header'=>'Kategoria',
			'name'=>'kategoria',
			'value'=>'$data->idZlecenia0->kategoria',
		),
		array(
			'header'=>'Poziom',
			'name'=>'poziom',
			'value'=>'$data->idZlecenia0->poziomStr',
		),
		array(
			'header'=>'Data',
			'name'=>'czasZakonczenia',
			'value'=>'$data->czasZakonczenia',
		),
		array(
			'header'=>'Status',
			'name'=>'idOdpowiedzi',
			'value'=>'(empty($data->idOdpowiedzi) ?
				("<span class=\"fail\">Niewykonane</span><br/>-" .  number_format($data->idZlecenia0->kwotaKary, 2, ",", "") . " zł") :
				("<span class=\"success\">Wykonane</span><br/>+" . number_format($data->idZlecenia0->cena, 2, ",", "") . " zł")) .
				( ' . ($showStudent?'true':'false') . ' ? "<br/>" . (isset($data->uczen)?("<a target=\"_blank\" href=\"" . Yii::app()->createUrl("/teacher/main/student",
					array("id"=>$data->idUcznia)) . "\">" . $data->uczen->imieNazwisko . "</a>"):"<i>n/a</i>") : "" )',
			'type'=>'raw'
		),
		array(
			'header'=>'<input ' . ($count?'':'class="disabled"') . ' type="checkbox" id="ordersSelectAll"/> <img class="disabled" id="printAll" title="Drukuj zaznaczone" alt="Drukuj zaznaczone" src="'.Yii::app()->controller->module->assetsUrl.'/images/print.png" />',
			'cssClassExpression'=>'"pleaseCenterAlignThisColumnForMe"',
			'type'=>'raw',
			'value'=>'"<div style=\"margin-right:2px\">
				<input value=\"" . $data->id . "\" type=\"checkbox\" name=\"orders[]\"/>
				<a href=\"javascript:printOrders({orders:[" . $data->id . "]})\">
					<img title=\"Drukuj\" alt=\"Drukuj\" src=\"'.Yii::app()->controller->module->assetsUrl.'/images/print.png\" />
				</a></div>"
			',
			//($data->idOdpowiedzi==null ? ("<br/><a target=\"_blank\" href=\"" . Yii::app()->CreateUrl("/teacher/main/acceptOrder", array("id"=>$data->id)) . "\"><img title=\"Zatwierdź\" alt=\"Zatwierdź\" src=\"' . $this->module->assetsUrl . '/images/gui/button_tick.png\" /></a>") : "")
		),
		array(
			'header'=>'',
			'value'=>'(empty($data->idGrupyPrzetargowej) ? ("<img task-id=\"" . $data->id . "\" new-status=\"" . (empty($data->idOdpowiedzi)?"1":"0")
				. "\" class=\"taskOrderUpdate\" " . (empty($data->idOdpowiedzi)?"alt=\"Niewykonane\" title=\"Niewykonane\"":"alt=\"Wykonane\" title=\"Wykonane\"")
				. " src=\"'.Yii::app()->controller->module->assetsUrl.'/images/" . (empty($data->idOdpowiedzi)?"refuse":"approve")
				. ".png\"/>"):"") . "</td></tr><tr><td colspan=\"8\"><div header-id=\"" . $data->id ."\">Szczegóły</div><div tresc-id=\"" . $data->id ."\">" .

				(empty($data->idZlecenia0->urlObrazka) ? "" :
				"<h1><img src=\"" . Yii::app()->baseUrl."/".$data->idZlecenia0->urlObrazka . "\"/></h1>") .
				"<p>" . $data->idZlecenia0->tresc . "</p>
				<div><u>Odpowiedzi</u>: " . implode(", ", array_values(CHtml::listData($data->idZlecenia0->odpowiedziZlecenia, "id", "odpowiedz"))) . "</div>
				<div><u>Udzielona odpowiedź</u>: <i>" . ($data->odpowiedz == null ? "brak odpowiedzi" : $data->odpowiedz) .
					($data->idZlecenia0->jednostka==null?"":" [".$data->idZlecenia0->jednostka."]") . "</i></div></div></td></tr>"',
			'type'=>'raw'
		)
	),
))
?>

<script type="text/javascript">
function printOrders(data) {
	<?php
		if (!empty($studentId))
			echo 'data.studentId = ' . $studentId . ';';
		else if (!empty($companyId))
			echo 'data.companyId = ' . $companyId . ';';
	?>
	var printUrl = '<?php echo Yii::app()->createUrl('/teacher/main/printOrder'); ?>';
	window.open(printUrl + '?' + $.param(data), '_blank');
}

(function()
{
	$('div[tresc-id]').hide();
	$('div[header-id]').off('click');
	$('div[header-id]').on('click', function(){
		var id = $(this).attr('header-id');
		var tab = $('div[tresc-id="' + id + '"]');
		var visible = tab.is(":visible");
		$('div[tresc-id]').hide();
		if (visible)
			tab.hide();
		else
			tab.show();
	});

	$('#ordersSelectAll').change(function(){
		var checked = $(this).is(':checked');
		$('[name="orders[]"]').prop('checked', checked);
		var count = $('[name="orders[]"]:checked').length;
		if (count)
			$('#printAll').removeClass('disabled');
		else
			$('#printAll').addClass('disabled');
	});
	$('[name="orders[]"]').change(function(){
		var count = $('[name="orders[]"]:checked').length;
		$('#ordersSelectAll').prop('checked', count == $('[name="orders[]"]').length);
		if (count)
			$('#printAll').removeClass('disabled');
		else
			$('#printAll').addClass('disabled');
	});

	$.datepicker.setDefaults( $.datepicker.regional['pl'] );
	$('.control-datapicker').datepicker({
		dateFormat: 'yy-mm-dd',
		dayNames: ['Niedziela', 'Poniedziałek', 'Wtorek', 'Środa', 'Czwartek',
			'Piątek', 'Sobota'],
		dayNamesMin: ['Nd', 'Pn', 'Wt', 'Śr', 'Cw', 'Pt', 'Sb'],
		monthNames: ['Styczeń', 'Luty', 'Marzec', 'Kwiecień', 'Maj', 'Czerwiec',
			'Lipiec', 'Sierpień', 'Wrzesień', 'Październik', 'Listopad', 'Grudzień']
	});
	$('.control-datapicker').focus(function(){
		$('.ui-datepicker').css('position', 'fixed');
	});
	$('#selectStartDate').datepicker('setDate', '-7');
	$('#selectStopDate').datepicker('setDate', '-0');

	$('#raportPrint').click(function(){
		printOrders({
			start: $('#selectStartDate').val(),
			stop: $('#selectStopDate').val(),
		});
	});
	$('#raportPrintAll').click(function(){
		printOrders({});
	});
	$('#printAll').click(function(){
		var array = [];
		$('[name="orders[]"]').each(function(index, element){
			var elem = $(element);
			if (elem.is(':checked'))
				array.push(elem.val());
		});
		printOrders({orders: array});
	});
/*
	$('.taskOrderUpdate').click(function()
	{
		var newStatus = $(this).attr('new-status');
		var taskId = $(this).attr('task-id');

		if (!confirm('Czy jestes pewien(a) że chcesz ' + (newStatus?'zaakceptować':'odrzucić') + ' to zlecenie?'))
			return;

		console.log('change status ' + taskId + ' ' + newStatus);
		$.ajax({
			url: '<?php echo Yii::app()->createUrl('/teacher/main/updateOrder'); ?>',
			type: 'POST',
			data: {
				taskId: taskId,
				status: newStatus
			},
			success: function(data) {
				console.log(data);
				if (data.error)
				{
				}
				else
				{
					window.location.reload(true);
				}
			},
			error: function() {
				console.log('critical error');
			}
		});
	});
*/
})();
</script>
